/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.IEditing;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;

public class EditingTracker {
    private IModConfig editingConfig;
    private static EditingTracker instance;

    public static EditingTracker instance() {
        if (instance == null) {
            instance = new EditingTracker();
        }
        return instance;
    }

    private EditingTracker() {
    }

    public static void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            EditingTracker tracker = EditingTracker.instance();
            if (screen instanceof IEditing) {
                IEditing editing = (IEditing)screen;
                if (tracker.editingConfig == null) {
                    tracker.editingConfig = editing.getActiveConfig();
                    tracker.editingConfig.startEditing();
                    Configured.LOGGER.info("Started editing '" + tracker.editingConfig.getFileName() + "'");
                } else {
                    if (editing.getActiveConfig() == null) {
                        throw new NullPointerException("A null config was returned when getting active config");
                    }
                    if (tracker.editingConfig != editing.getActiveConfig()) {
                        throw new IllegalStateException("Trying to edit a config while one is already loaded. This should not happen!");
                    }
                }
            } else if (tracker.editingConfig != null) {
                Configured.LOGGER.info("Stopped editing '" + tracker.editingConfig.getFileName() + "'");
                tracker.editingConfig.stopEditing();
                tracker.editingConfig = null;
            }
        });
    }
}

